<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8" />
        <title>HTML5 Scheduler</title>

        <style type="text/css">
            p, body, td { font-family: Tahoma, Arial, Helvetica, sans-serif; font-size: 10pt; }
            body { padding: 0px; margin: 0px; background-color: #ffffff; }
            a { color: #1155a3; }
            .space { margin: 10px 0px 10px 0px; }
            .header { background: #003267; background: linear-gradient(to right, #011329 0%,#00639e 44%,#011329 100%); padding:20px 10px; color: white; box-shadow: 0px 0px 10px 5px rgba(0,0,0,0.75); }
            .header a { color: white; }
            .header h1 a { text-decoration: none; }
            .header h1 { padding: 0px; margin: 0px; }
            .main { padding: 10px }
        </style>

        <!-- DayPilot library -->
        <script src="js/daypilot/daypilot-all.min.js"></script>

        <!-- helper libraries -->
	<script src="js/jquery-1.9.1.min.js" type="text/javascript"></script>

    </head>
    <body>
        <div class="header">
            <h1><a href='https://code.daypilot.org/87166/html5-scheduler'>HTML5 Scheduler</a></h1>
            <div><a href="https://javascript.daypilot.org/">DayPilot for JavaScript</a> - AJAX Calendar/Scheduling Widgets for JavaScript/HTML5/jQuery/AngularJS</div>
        </div>

        <div class="main">
          <div id="dp"></div>
        </div>


            <script type="text/javascript">
                var dp = new DayPilot.Scheduler("dp");

                dp.treeEnabled = true;

                dp.scale = "Day";
                dp.startDate = new DayPilot.Date().firstDayOfMonth();
                dp.days = dp.startDate.daysInMonth();

                dp.timeHeaders = [
                    { groupBy: "Month", format: "MMMM yyyy" },
                    { groupBy: "Day", format: "d"}
                ];

                dp.cellWidthSpec = "Auto";
                dp.eventHeight = 40;

                dp.eventDeleteHandling = "Update";

                // http://api.daypilot.org/daypilot-scheduler-oneventmoved/
                dp.onEventMoved = function (args) {
                    $.post("backend_move.php",
                    {
                        id: args.e.id(),
                        newStart: args.newStart.toString(),
                        newEnd: args.newEnd.toString(),
                        newResource: args.newResource
                    },
                    function() {
                        dp.message("Moved.");
                    });
                };

                // http://api.daypilot.org/daypilot-scheduler-oneventresized/
                dp.onEventResized = function (args) {
                    $.post("backend_resize.php",
                    {
                        id: args.e.id(),
                        newStart: args.newStart.toString(),
                        newEnd: args.newEnd.toString()
                    },
                    function() {
                        dp.message("Resized.");
                    });
                };

                dp.onEventDeleted = function(args) {
                    $.post("backend_delete.php",
                    {
                        id: args.e.id()
                    },
                    function() {
                        dp.message("Deleted.");
                    });
                };

                dp.onTimeRangeSelected = function (args) {
                    var url = "new.php?start=" +args. start + "&end=" + args.end + "&resource=" + args.resource;

                    var modal = new DayPilot.Modal();
                    modal.onClosed = function(args) {
                        dp.clearSelection();
                        var data = args.result;
                        if(data && data.result==="OK") { loadEvents(); dp.message(data.message); }
                        if(data && data.result==="ERROR") { loadEvents(); dp.message("Error: " + data.message); }
                    };
                    modal.showUrl(url);
                };

                dp.onEventClick = function(args) {
                    var modal = new DayPilot.Modal();
                    modal.closed = function() {
                        // reload all events
                        var data = this.result;
                        if (data && data.result === "OK") {
                            loadEvents();
                        }
                    };
                    modal.showUrl("edit.php?id=" + args.e.id());
                };

                dp.init();

                loadResources();
                loadEvents();

                function loadEvents() {
                    var start = dp.startDate;
                    var end = dp.startDate.addDays(dp.days);

                    $.post("backend_events.php",
                        {
                            start: start.toString(),
                            end: end.toString()
                        },
                        function(data) {
                            dp.events.list = data;
                            dp.update();
                        }
                    );
                }

                function loadResources() {
                    $.post("backend_resources.php", function(data) {
                        dp.resources = data;
                        dp.update();
                    });
                }

            </script>



    </body>
</html>